# -*- coding: UTF-8 -*-

import re
import yaml
import json
from yaml.loader import SafeLoader
from ansibleext.inventory_base import InventoryBase
import typing


class HashesGroups(InventoryBase):

    def runTest(self):
        hashes = self.load_hashes()
        user_groups_generated_devels = self.eval_user_groups_generated(hashes, "devels")
        password_hashes = hashes.get("password_hashes")
        gpgkeys = hashes.get("gpgkeys")
        vpn_cert_names = hashes.get("vpn_cert_names")

        user_groups_generated_devels_password_hashes_diff = user_groups_generated_devels.difference(set(password_hashes.keys()))
        self.assertTrue(not bool(user_groups_generated_devels_password_hashes_diff), f'There are some users in user_groups_generated.devels (in hashes.yml file), which is not in password_hashes (in hashes.yml file). These users should be in password_hashes too: {user_groups_generated_devels_password_hashes_diff}')

        user_groups_generated_devels_gpgpkeys_diff = user_groups_generated_devels.difference(set(gpgkeys.keys()))
        self.assertTrue(not bool(user_groups_generated_devels_gpgpkeys_diff), f'There are some users in user_groups_generated.devels (in hashes.yml file), which is not in gpgkeys (in hashes.yml file). These users should be in gpgkeys too: {user_groups_generated_devels_gpgpkeys_diff}')

        user_groups_generated_devels_vpn_cert_names_diff = user_groups_generated_devels.difference(set(vpn_cert_names.keys()))
        self.assertTrue(not bool(user_groups_generated_devels_vpn_cert_names_diff), f'There are some users in user_groups_generated.devels (in hashes.yml file), which is not in vpn_cert_names (in hashes.yml file). These users should be in vpn_cert_names too: {user_groups_generated_devels_gpgpkeys_diff}')

    def eval_user_groups_generated(self, hashes: dict, generated: str) -> set:
        user_groups = "user_groups"
        regexp = re.compile(user_groups + ".([a-z]*)")
        group_names = regexp.findall(json.dumps(hashes["user_groups_generated"][generated]))
        users = set() # type: ignore
        for group in group_names:
            hashesForGroup = hashes[user_groups][group]
            if hashesForGroup:
                groupkeys = hashesForGroup.keys()
                users = users.union(set(groupkeys))
        return users

    def load_hashes(self) -> dict:
        with open('credentials/generic/hashes.yml') as hashes_file:
            hashes = yaml.load(hashes_file, Loader=SafeLoader)
            return hashes
