# -*- coding: UTF-8 -*-

import re
import yaml
from ansibleext.inventory_base import InventoryBase

class CheckPortforwardRules(InventoryBase):
	def __checkSibrik(self, portforwards):
		for forwardRule in portforwards['forward_target_sibrik']:
			self.__checkIpIsInNetworkGroup(forwardRule['extip'], 'ilka_net')
			self.__checkIpIsInNetworkGroup(forwardRule['ip'], 'sibrik_net')

	def __checkIlka(self, portforwards):
		for forwardRule in portforwards['forward_target_ilka']:
			self.__checkIpIsInNetworkGroup(forwardRule['extip'], 'ilka_net')
			self.__checkIpIsInNetworkGroup(forwardRule['ip'], 'ilka_net')

	def __checkIpIsInNetworkGroup(self, ipAsTemplate, network):
		hostname = self.__getHostnameFromIpTemplate(ipAsTemplate)
		inventory, host = self.__getInventoryAndHostByItsName(hostname)

		self.assertTrue(self.groupNamesContain(inventory, host, network),
			'Host {} is not in {} group'.format(host.get_name(), network))

	def __getHostnameFromIpTemplate(self, template):
		hostnameRegex = r"{{ hostvars\['([a-zA-Z0-9_-]+)'\].primary_ip }}"
		regexResult = re.search(hostnameRegex, template)
		if regexResult == None:
			self.fail('The provided IP ("{}") doesn\'t match for regex. ("{}")'.format(template, hostnameRegex))

		captureGroups = regexResult.groups()

		if len(captureGroups) != 1:
			self.fail('One capture group is expected, but there are {}. The captured groups: {}'.format(len(captureGroups), captureGroups))

		return captureGroups[0]

	def __getInventoryAndHostByItsName(self, hostname):
		for inventory, host in self.inventories_hosts():
			if host.get_name() == hostname:
				return (inventory, host)

		self.fail('IP not found for host {}'.format(hostname))

	def runTest(self):
		with open('playbooks/roles/portforward-rules/vars/main.yml', 'r') as stream:
			portforwards = yaml.load(stream, Loader=yaml.SafeLoader)['idata_ilka']['portforward_rules']

		self.__checkSibrik(portforwards)
		self.__checkIlka(portforwards)
