# -*- coding: UTF-8 -*-

import os
import re
import glob

from ansibleext.inventory_base import InventoryBase
from typing import List

class LineMatch:
    def __init__(self, line: int, mymatch: str):
        self.line = line
        self.mymatch = mymatch

class InvalidChars(InventoryBase):

    def is_utf8_bom(self, file_path: str, skip_files: List[str]) -> bool:
        if list(filter(file_path.endswith, skip_files)) != []:
            return False
        with open(file_path, 'rb') as file:
            first_bytes = file.read(3)
        return first_bytes[0:3] == b'\xef\xbb\xbf'

    def find_invalid_chars(self, file_path: str, invalid_chars: str, skip_files: List[str]) -> List[LineMatch]:
        matches: List[LineMatch] = []
        if list(filter(file_path.endswith, skip_files)) != []:
            return matches
        try:
            for i, line in enumerate(open(file_path)):
                for match in re.finditer(invalid_chars, line):
                    matches.append(LineMatch(i+1, match.group()))
            return matches
        except:
            return matches

    def test_find_invalid_chars(self) -> None:
        invalid_chars = chr(0xa0)
        skip_files: List[str] = ["reports/junit/pytest.xml", "fake_space_a0.txt", "utf8_bom_rsa.txt"]
        errors: List[str] = []
        utf8_bom_errors: List[str] = []
        for filename in glob.iglob("./**", recursive=True):
            if os.path.isfile(filename):
                if self.is_utf8_bom(filename, skip_files):
                    utf8_bom_errors.append(f"utf8 bom found in {filename}")
                matches = self.find_invalid_chars(filename, invalid_chars, skip_files)
                if matches:
                    errors_in_file = [f'Invalid character found in {filename} at line {line_match.line}: {line_match.mymatch}' for line_match in matches]
                    errors.extend(errors_in_file)
        self.assertEqual(errors, [])
        self.assertEqual(utf8_bom_errors, [])
