# -*- coding: UTF-8 -*-

import os
import ansible.template # type: ignore
import pytest


def all_paths():
    for dirpath, _, filenames in os.walk('playbooks'):
        for file in filenames:
            if '.j2' in file or file.endswith('.rules'):
                path = os.path.join(dirpath, file)
                yield path


@pytest.mark.parametrize("path", all_paths())
def testJinja2Valid(path):
    templar = ansible.template.Templar(None)
    myenv = templar.environment.overlay()
    myenv.get_template(path)
