# -*- coding: UTF-8 -*-

from ansibleext.inventory_base import InventoryBase


class PromtailRequirements(InventoryBase):

    def isPromtailRequired(self, inventory, host):
        promtailRequired = self.getVariable(inventory, host, 'promtail_required')
        return promtailRequired is not None and promtailRequired

    def isNonClusterSpecific(self, inventory, host):
        return self.isHostInAnyGroups(inventory, host, ('nonclusterspecific',))

    def getRequiredVariable(self, inventory, host, name: str):
        var = self.getVariable(inventory, host, name)
        self.assertIsNotNone(var, "variable %s is required on host %s but it is missing" % (name, host))
        return var

    def findScraper(self, scrapers, name: str):
        found = [scraper for scraper in scrapers if scraper['job_name'] == name]
        if len(found) == 0:
            return None
        return found[0]

    def test_hwns_are_ssh_audited(self):
        for inventory, host in self.inventories_hosts_onlystable():
            if not self.isPromtailRequired(inventory, host):
                continue
            excludedGroups = ('employee', 'office_hwn', 'gyartas_hwn', 'testing_win_hwn', 'itrack_dispatcher',)
            if self.isHostInAnyGroups(inventory, host, excludedGroups):
                continue
            if not self.groupNamesContain(inventory, host, 'hwn'):
                continue

            promtailInstances = self.getRequiredVariable(inventory, host, 'promtail_instances')
            self.assertIsInstance(promtailInstances, list,
                                  "promtail_instances is present on %s but is not a list" % (host))
            self.assertIn('promtail-audit', promtailInstances, "promtail_instances must contain audit on %s" % (host))

            auditScrapeConfig = self.getRequiredVariable(inventory, host, 'promtail_audit_scrape_config')
            self.assertIsInstance(auditScrapeConfig, list,
                                  "promtail_audit_scrape_config is present on %s but is not a list" % (host))
            sshAuditScraper = self.findScraper(auditScrapeConfig, 'sshaudit')
            self.assertTrue(sshAuditScraper is not None, 'scraper named sshaudit must exist for host %s' % (host))
