# -*- coding: UTF-8 -*-

import os
import pytest
import xml.sax
from xml.sax.handler import ContentHandler

def all_xmls():
    for dirpath, _, filenames in os.walk('.'):
        for file in filenames:
            if file.endswith('.xml'):
                path = os.path.join(dirpath, file)
                yield path

@pytest.mark.parametrize("path", all_xmls())
def testXmlValid(path):
    parser = xml.sax.make_parser()
    parser.setContentHandler(ContentHandler())
    parser.parse(path)
