# -*- coding: UTF-8 -*-

import sys
import yaml
from collections import OrderedDict
from ansible.parsing.yaml.objects import AnsibleUnicode # type: ignore
from yaml.representer import RepresenterError # type: ignore
from ansible.utils.unsafe_proxy import AnsibleUnsafeText # type: ignore

"""Make PyYAML output an OrderedDict.
It will do so fine if you use yaml.dump(), but that generates ugly, non-standard YAML code.
To use yaml.safe_dump(), you need the following.
"""
def setup_represent_ordered_dict():
    represent_dict_order = lambda self, data: self.represent_mapping('tag:yaml.org,2002:map', data.items())
    yaml.SafeDumper.add_representer(OrderedDict, represent_dict_order)

def setup_represent_ansibleunicode():
    represent_unicode = lambda self, data: self.represent_scalar('tag:yaml.org,2002:str', str(data))
    yaml.SafeDumper.add_representer(AnsibleUnicode, represent_unicode)

def setup_represent_ansibleunsafe():
    represent_unsafe = lambda self, data: self.represent_scalar('tag:yaml.org,2002:str', str(data))
    yaml.SafeDumper.add_representer(AnsibleUnsafeText, represent_unsafe)

def setup_represent_undefined():
    def represent_undefined(self, data):
        raise RepresenterError("cannot represent an object: {} of type {}".format(data, type(data)))
    yaml.SafeDumper.add_representer(None, represent_undefined)

def prettydump(data):
    setup_represent_ordered_dict()
    setup_represent_ansibleunicode()
    setup_represent_ansibleunsafe()
    setup_represent_undefined()
    yaml.safe_dump(data, stream=sys.stdout, default_flow_style=False, allow_unicode=True, indent=4)
