# -*- coding: UTF-8 -*-

import yaml
from ansible.parsing.yaml.objects import AnsibleUnicode # type: ignore

def add_ansible_representers():
    yaml.add_representer(AnsibleUnicode, _represent_ansible_unicode, Dumper=yaml.SafeDumper)

def _represent_ansible_unicode(dumper, instance):
    string_value = str(instance)
    return dumper.represent_str(string_value)
