from setuptools import setup  # type: ignore

setup(
    name='idata-infra',
    version='1.2.1',
    description='idata-infra -- ansible and idump CLI tool to gather and export information about inventories',
    url='https://pip.idata.hu/simple',
    packages=['idump', 'ansibleext', 'idata_cassandra'],
    install_requires=['ansible==10.5.0', 'distro', 'jmespath', 'cassandra-driver'],
    entry_points={
        "console_scripts": [
            "idump=idump.idump:main",
            "cassandra_copy=idata_cassandra.cassandra_copy:main",
            "cassandra_truncate=idata_cassandra.cassandra_truncate:main",
        ],
    }
)
