# -*- coding: UTF-8 -*-

import sys
import unittest
sys.path.append('.')
from playbooks.filter_plugins.apt import extract_packages_will_be_removed


class TestGetPackagesWillBeRemoved(unittest.TestCase):
    def testPackagesWillBeRemovedEmpty(self):
        apt_output_v2_0_10 = '''
Reading package lists... Done
Building dependency tree       
Reading state information... Done
Calculating upgrade... Done
The following package was automatically installed and is no longer required:
  pavucontrol-qt-l10n
Use 'sudo apt autoremove' to remove it.
Get more security updates through Ubuntu Pro with 'esm-apps' enabled:
  vlc-bin vlc-plugin-video-output libavformat58 libavfilter7 mc liburiparser1
  vlc-plugin-samba libmagickcore-6.q16-6-extra imagemagick libmaven3-core-java
  libswresample3 vlc-plugin-qt libgegl-0.4-0 ant libzmq5 python2.7-minimal
  libhdf5-103 libmagickwand-6.q16-6 vlc-plugin-skins2 libgegl-common
  vlc-plugin-visualization vlc-l10n python2.7 vlc-plugin-notify libvlc5
  mc-data libpostproc55 libvlccore9 libvlc-bin ntpdate imagemagick-6.q16 maven
  libeditorconfig0 libavcodec58 vlc libavutil56 vlc-data libswscale5
  libopenexr24 libsdl2-2.0-0 libmysofa1 libmagickcore-6.q16-6
  vlc-plugin-video-splitter libpython2.7-minimal vlc-plugin-base
  libpython2.7-stdlib traceroute imagemagick-6-common
Learn more about Ubuntu Pro at https://ubuntu.com/pro
The following packages will be upgraded:
  elisa google-chrome-stable
2 upgraded, 0 newly installed, 0 to remove and 0 not upgraded.
Need to get 108 MB of archives.
After this operation, 81,9 kB of additional disk space will be used.
'''
        assert extract_packages_will_be_removed(apt_output_v2_0_10) == []

    def testFullAptOutput(self):
        apt_output_v2_4_11 = '''
Reading package lists...
Building dependency tree...
Reading state information...
The following packages were automatically installed and are no longer required:
  libffi7 libgeos-3.7.1 liblwgeom-2.5-0 libproj12 libpython2-stdlib python2
  python2-minimal
Use 'apt autoremove' to remove them.
The following additional packages will be installed:
  libllvm15 libpq5 postgresql-13 postgresql-client-13
Suggested packages:
  postgresql-doc-13
The following packages will be REMOVED:
  libldap-2.4-2 libllvm6.0 libssl1.1
The following NEW packages will be installed:
  libllvm15
The following packages will be upgraded:
  libpq5 postgresql-13 postgresql-client-13
3 upgraded, 1 newly installed, 3 to remove and 6 not upgraded.
Inst libpq5 [15.3-1.pgdg22.04+1] (16.1-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
Inst postgresql-client-13 [13.11-1.pgdg22.04+1] (13.13-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
Inst libllvm15 (1:15.0.7-0ubuntu0.22.04.3 Ubuntu:22.04/jammy-updates, Ubuntu:22.04/jammy-security [amd64])
Inst postgresql-13 [13.11-1.pgdg22.04+1] (13.13-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
Remv libldap-2.4-2 [2.4.49+dfsg-2ubuntu1.9]
Remv libllvm6.0 [1:6.0.1-14]
Remv libssl1.1 [1.1.1f-1ubuntu2.20]
Conf libpq5 (16.1-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
Conf postgresql-client-13 (13.13-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
Conf libllvm15 (1:15.0.7-0ubuntu0.22.04.3 Ubuntu:22.04/jammy-updates, Ubuntu:22.04/jammy-security [amd64])
Conf postgresql-13 (13.13-1.pgdg22.04+1 PostgreSQL for Debian/Ubuntu repository:jammy-pgdg [amd64])
        '''
        assert extract_packages_will_be_removed(apt_output_v2_4_11) == ["libldap-2.4-2", "libllvm6.0", "libssl1.1"]

    def testPackagesWillBeRemovedThreeLine(self):
        apt_output = '''
Reading package lists...
Building dependency tree...
Reading state information...
...
Recommended packages:
  openssh-server
The following packages will be REMOVED:
  brltty firefox gdb google-chrome-stable gparted irqbalance libcc1-0 libglu1-mesa libllvm6.0 libmagickcore-6.q16-3-extra
  libpagemaker-0.0-0 libproxy1-plugin-gsettings libreoffice-avmedia-backend-gstreamer libreoffice-base-core libreoffice-calc
  libreoffice-draw libreoffice-gnome libreoffice-gtk3 libreoffice-help-en-us libreoffice-impress libreoffice-math
The following NEW packages will be installed:
  ssh-import-id
...
'''
        expected_packages_will_be_removed = ["brltty", "firefox", "gdb", "google-chrome-stable", "gparted", "irqbalance",
                                             "libcc1-0", "libglu1-mesa", "libllvm6.0", "libmagickcore-6.q16-3-extra",
                                             "libpagemaker-0.0-0", "libproxy1-plugin-gsettings",
                                             "libreoffice-avmedia-backend-gstreamer", "libreoffice-base-core", "libreoffice-calc",
                                             "libreoffice-draw", "libreoffice-gnome", "libreoffice-gtk3", "libreoffice-help-en-us",
                                             "libreoffice-impress", "libreoffice-math"]
        assert extract_packages_will_be_removed(apt_output) == expected_packages_will_be_removed

    def testEmptyInput(self):
        apt_output = ''
        with self.assertRaisesRegex(ValueError, 'Invalid apt output.'):
            extract_packages_will_be_removed(apt_output)

    def testRandomInput(self):
        apt_output = '''
Lorem Ipsum is simply dummy text of the printing and typesetting industry.
Lorem Ipsum has been the industry's standard dummy text ever since the 1500s,
when an unknown printer took a galley of type and scrambled it to make a type specimen book.
'''
        with self.assertRaisesRegex(ValueError, 'Invalid apt output.'):
            extract_packages_will_be_removed(apt_output)
