# -*- coding: UTF-8 -*-

import os
import pathlib
from deadlockdetect.deadlockdetect import parse_jstack, gen_metrics
from fileinput import FileInput

TESTFILE_FOLDER = os.path.join(os.path.dirname(__file__), 'data')

def test_parser_two_deadlocks():
  with FileInput(files=(pathlib.PurePath(TESTFILE_FOLDER, 'deadlockdetect-test1'))) as stackiterator:
    deadlocks = parse_jstack(stackiterator, "EDU.oswego", 2)
    assert len(deadlocks) == 2
    metrics = gen_metrics(deadlocks, "test1").splitlines()
    assert metrics[0] == r'java_deadlock_count{systemd_name="test1"} 2.0'
    assert metrics[1] == r'java_blocked_thread_count{systemd_name="test1"} 4.0'

def test_parser_one_deadlock1():
  with FileInput(files=(pathlib.PurePath(TESTFILE_FOLDER, 'deadlockdetect-test2'))) as stackiterator:
    deadlocks = parse_jstack(stackiterator, "hu.idata", 2)
    assert len(deadlocks) == 1

def test_parser_one_deadlock2():
  with FileInput(files=(pathlib.PurePath(TESTFILE_FOLDER, 'deadlockdetect-test3'))) as stackiterator:
    deadlocks = parse_jstack(stackiterator, "hu.idata", 2)
    assert len(deadlocks) == 1

def test_parser_no_deadlock():
  with FileInput(files=(pathlib.PurePath(TESTFILE_FOLDER, 'deadlockdetect-test4'))) as stackiterator:
    deadlocks = parse_jstack(stackiterator, "hu.idata", 2)
    assert len(deadlocks) == 0
